-- GILCHRIST 

SET SQL_SAFE_UPDATES=0;

-- 1)Manual Bill Generation
SET @manualBillGeneration=(SELECT id FROM dtprovider WHERE `dataProviderName`='MSG_MANUAL_BILL_GENERATION_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="
SELECT
T1.id AS ID,
T4.`salutationName` AS SALUTATION_NAME,
T2.`firstName` AS FIRST_NAME,
T2.`middleName` AS MIDDLE_NAME,
T2.`lastName` AS LAST_NAME,
T2.`emailId` AS EMAIL_ID,
T2.`mobileNumber` AS MOBILE_NO,
T1.`totalAmount` AS TOTAL_AMOUNT,
T6.`currencyCode` AS CURRENCY_CODE,
T1.`billingDate` AS BILLING_DATE,
T1.`billNo` AS BILL_NO,
T1.`raiseBillCategory` AS RAISE_BILL_CATEGORY,
ml.code as LANGUAGE_KEY
FROM bill_header T1
inner join application T7 on T7.id=T1.applicantId
inner join applicant_person T2 on T2.id = T7.applicantPersonId
inner join salutations T4 on T4.id = T2.salutationId
inner join currency T6 on T6.id = T1.currencyId
LEFT JOIN multi_language ml on ml.id=T2.correspondence_language 
WHERE T1.ID in (namedParams)
UNION
SELECT
T1.id AS ID,
T4.`salutationName` AS SALUTATION_NAME,
T3.`firstName` AS FIRST_NAME,
T3.`middleName` AS MIDDLE_NAME,
T3.`lastName` AS LAST_NAME,
T3.`emailId` AS EMAIL_ID,
T3.`mobileNumber` AS MOBILE_NO,
T1.`totalAmount` AS TOTAL_AMOUNT,
T6.`currencyCode` AS CURRENCY_CODE,
T1.`billingDate` AS BILLING_DATE,
T1.`billNo` AS BILL_NO,
T1.`raiseBillCategory` AS RAISE_BILL_CATEGORY,
ml.code as LANGUAGE_KEY
FROM bill_header T1
inner join students T2 ON T2.userId = T1.studentId
inner join persons T3 on T3.id = T2.personId
inner join salutations T4 on T4.id = T3.salutationId
inner join currency T6 on T6.id = T1.currencyId
LEFT JOIN multi_language ml on ml.id=T3.correspondence_language
WHERE T1.id in (namedParams)
UNION
SELECT
T1.id AS ID,
T3.`contactName` AS SALUTATION_NAME,
T2.`sponsorName` AS FIRST_NAME,
T3.`designation` AS MIDDLE_NAME,
T3.`designation` AS LAST_NAME,
T4.`primaryeEmailId` AS EMAIL_ID,
T4.`cellNo` AS MOBILE_NO,
T1.`totalAmount` AS TOTAL_AMOUNT,
T6.`currencyCode` AS CURRENCY_CODE,
T1.`billingDate` AS BILLING_DATE,
T1.`billNo` AS BILL_NO,
T1.`raiseBillCategory` AS RAISE_BILL_CATEGORY
FROM bill_header T1
inner join sponsors T2 ON T1.sponsorId = T2.id
inner join sponsor_contacts T3 on T3.sponsorId = T2.id
inner join address T4 on T4.id = T3.addressId
inner join currency T6 on T6.id = T1.currencyId
WHERE T1.ID in (namedParams)
UNION
SELECT
T1.id AS ID,
T7.`salutationName` AS SALUTATION_NAME,
T4.`firstName` AS FIRST_NAME,
T4.`middleName` AS MIDDLE_NAME,
T4.`lastName` AS LAST_NAME,
T4.`emailId` AS EMAIL_ID,
T4.`mobileNumber` AS MOBILE_NO,
T1.`totalAmount` AS TOTAL_AMOUNT,
T6.`currencyCode` AS CURRENCY_CODE,
T1.`billingDate` AS BILLING_DATE,
T1.`billNo` AS BILL_NO,
T1.`raiseBillCategory` AS RAISE_BILL_CATEGORY,
ml.code as LANGUAGE_KEY
FROM bill_header T1
inner join users T2 ON T1.userId = T2.id
inner join staffs T3 ON T3.userId = T2.id
inner join persons T4 on T4.id = T3.personId
inner join currency T6 on T6.id = T1.currencyId
inner join salutations T7 on T4.salutationId = T7.id
LEFT JOIN multi_language ml on ml.id=T4.correspondence_language
WHERE T1.ID in (namedParams);
" WHERE `dataProviderId`=@manualBillGeneration;  

-- 2)DAILY_RECEIPT_DETAILS , 3)DAILY_BILLS_DETAILS ,4)DAILY_PAYMENT_DETAILS
SET @dailyReceiptDetails=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_OWNER_DTP');

UPDATE `sql_dtprovider` SET `sqlQuery`=
"SELECT 
    T2.id AS ID,
    T4.`salutationName` AS SALUTATION_NAME,
    T2.`firstName` AS FIRST_NAME,
    T2.`middleName` AS MIDDLE_NAME,
    T2.`lastName` AS LAST_NAME,
    T3.`emailId` AS EMAIL_ID,
    T3.`mobileNumber` AS MOBILE_NO,
    ml.code as LANGUAGE_KEY
FROM
    `staffs` T1
        INNER JOIN
    `users` T2 ON T2.`id` = T1.`userId`
        INNER JOIN
    `persons` T3 ON T3.`id` = T1.`personId`
        LEFT JOIN
    `salutations` T4 ON T4.`id` = T3.`salutationId`
    LEFT JOIN 
    multi_language ml on ml.id=T3.correspondence_language 
WHERE
    T2.id IN (namedParams)" WHERE `dataProviderId`=@dailyReceiptDetails;  

    
 -- 5)MSG_MANUAL_RECEIPT
 SET @msgManualReceipt=(SELECT id FROM dtprovider WHERE `dataProviderName`='MSG_MANUAL_RECEIPT_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`=
"SELECT
T1.id AS ID,
T4.`salutationName` AS SALUTATION_NAME,
T2.`firstName` AS FIRST_NAME,
T2.`middleName` AS MIDDLE_NAME,
T2.`lastName` AS LAST_NAME,
T2.`emailId` AS EMAIL_ID,
T2.`mobileNumber` AS MOBILE_NO,
T1.`amount` AS AMOUNT,
T6.`currencyCode` AS CURRENCY_CODE,
ml.code as LANGUAGE_KEY,
CONCAT(SUBSTRING(T1.`transactionDate`,9,2),'-',SUBSTRING(T1.`transactionDate`,6,2),'-',SUBSTRING(T1.`transactionDate`,1,4)) AS TRANSACTION_DATE,
T1.`receiptNo` AS RECEIPT_NO,
(CASE
	WHEN (T1.`status` = 'FULLY_PENDING') 
		THEN 'Fully pending'
	WHEN (T1.`status` = 'PARTLY_SETTLED') 
		THEN 'Partly settled'
	WHEN (T1.`status` = 'SETTLED') 
		THEN 'Settled'
	WHEN (T1.`status` = 'CANCELLED') 
		THEN 'Cancelled'
	WHEN (T1.`status` = 'REVERSED') 
		THEN 'Reversed'
END) AS STATUS
FROM receipt_header T1
inner join application T7 on T7.id=T1.applicantId
inner join applicant_person T2 on T2.id = T7.applicantPersonId
inner join salutations T4 on T4.id = T2.salutationId
inner join currency T6 on T6.id = T1.currencyId
LEFT JOIN multi_language ml on ml.id=T2.correspondence_language
WHERE T1.ID in (namedParams)
UNION
SELECT
T1.id AS ID,
T4.`salutationName` AS SALUTATION_NAME,
T3.`firstName` AS FIRST_NAME,
T3.`middleName` AS MIDDLE_NAME,
T3.`lastName` AS LAST_NAME,
T3.`emailId` AS EMAIL_ID,
T3.`mobileNumber` AS MOBILE_NO,
T1.`amount` AS AMOUNT,
T6.`currencyCode` AS CURRENCY_CODE,
ml.code as LANGUAGE_KEY,
CONCAT(SUBSTRING(T1.`transactionDate`,9,2),'-',SUBSTRING(T1.`transactionDate`,6,2),'-',SUBSTRING(T1.`transactionDate`,1,4)) AS TRANSACTION_DATE,
T1.`receiptNo` AS RECEIPT_NO,
(CASE
	WHEN (T1.`status` = 'FULLY_PENDING') 
		THEN 'Fully pending'
	WHEN (T1.`status` = 'PARTLY_SETTLED') 
		THEN 'Partly settled'
	WHEN (T1.`status` = 'SETTLED') 
		THEN 'Settled'
	WHEN (T1.`status` = 'CANCELLED') 
		THEN 'Cancelled'
	WHEN (T1.`status` = 'REVERSED') 
		THEN 'Reversed'
END) AS STATUS
FROM receipt_header T1
inner join students T2 ON T2.userId = T1.studentId
inner join persons T3 on T3.id = T2.personId
inner join salutations T4 on T4.id = T3.salutationId
inner join currency T6 on T6.id = T1.currencyId
LEFT JOIN multi_language ml on ml.id=T3.correspondence_language
WHERE T1.id in (namedParams)
UNION
SELECT
T1.id AS ID,
T3.`contactName` AS SALUTATION_NAME,
T2.`sponsorName` AS FIRST_NAME,
T3.`designation` AS MIDDLE_NAME,
T3.`designation` AS LAST_NAME,
T4.`primaryeEmailId` AS EMAIL_ID,
T4.`cellNo` AS MOBILE_NO,
T1.`amount` AS AMOUNT,
T6.`currencyCode` AS CURRENCY_CODE,
CONCAT(SUBSTRING(T1.`transactionDate`,9,2),'-',SUBSTRING(T1.`transactionDate`,6,2),'-',SUBSTRING(T1.`transactionDate`,1,4)) AS TRANSACTION_DATE,
T1.`receiptNo` AS RECEIPT_NO,
(CASE
	WHEN (T1.`status` = 'FULLY_PENDING') 
		THEN 'Fully pending'
	WHEN (T1.`status` = 'PARTLY_SETTLED') 
		THEN 'Partly settled'
	WHEN (T1.`status` = 'SETTLED') 
		THEN 'Settled'
	WHEN (T1.`status` = 'CANCELLED') 
		THEN 'Cancelled'
	WHEN (T1.`status` = 'REVERSED') 
		THEN 'Reversed'
END) AS STATUS
FROM receipt_header T1
inner join sponsors T2 ON T1.sponsorId = T2.id
inner join sponsor_contacts T3 on T3.sponsorId = T2.id
inner join address T4 on T4.id = T3.addressId
inner join currency T6 on T6.id = T1.currencyId
WHERE T1.ID in (namedParams)
UNION
SELECT
T1.id AS ID,
T7.`salutationName` AS SALUTATION_NAME,
T4.`firstName` AS FIRST_NAME,
T4.`middleName` AS MIDDLE_NAME,
T4.`lastName` AS LAST_NAME,
T4.`emailId` AS EMAIL_ID,
T4.`mobileNumber` AS MOBILE_NO,
T1.`amount` AS AMOUNT,
T6.`currencyCode` AS CURRENCY_CODE,
ml.code as LANGUAGE_KEY,
CONCAT(SUBSTRING(T1.`transactionDate`,9,2),'-',SUBSTRING(T1.`transactionDate`,6,2),'-',SUBSTRING(T1.`transactionDate`,1,4)) AS TRANSACTION_DATE,
T1.`receiptNo` AS RECEIPT_NO,
(CASE
	WHEN (T1.`status` = 'FULLY_PENDING') 
		THEN 'Fully pending'
	WHEN (T1.`status` = 'PARTLY_SETTLED') 
		THEN 'Partly settled'
	WHEN (T1.`status` = 'SETTLED') 
		THEN 'Settled'
	WHEN (T1.`status` = 'CANCELLED') 
		THEN 'Cancelled'
	WHEN (T1.`status` = 'REVERSED') 
		THEN 'Reversed'
END) AS STATUS
FROM receipt_header T1
inner join users T2 ON T1.userId = T2.id
inner join staffs T3 ON T3.userId = T2.id
inner join persons T4 on T4.id = T3.personId
inner join currency T6 on T6.id = T1.currencyId
inner join salutations T7 on T4.salutationId = T7.id
LEFT JOIN multi_language ml on ml.id=T4.correspondence_language
WHERE T1.ID in (namedParams)
" WHERE `dataProviderId`=@msgManualReceipt;  

-- 6)OUTSTANDING_BILL_STUDENT_REMINDER_ON_DUE_DAY

SET @studentReminderOnDueDay=(SELECT id FROM dtprovider WHERE `dataProviderName`='OUTSTANDING_BILL_STU_REM_ON_DAY_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`=
"SELECT 
    bh.id AS ID,
    SUM(bfprs.balanceAmount) as OUTSTANDING_AMT,
    bh.studentId,
    p.emailId AS EMAIL_ID,
    p.mobileNumber AS MOBILE_NO,
    p.mobileCountryCode AS MOBILE_CODE,
    p.printName AS PRINT_NAME,
    p.firstName AS FIRST_NAME,
    p.lastName AS LAST_NAME,
    sal.salutationName AS SALUTATION_NAME,
    bh.billNo AS BILL_NO,
    DATE_FORMAT(bh.billingDate, '%d-%m-%Y') AS BILL_DATE,
    DATE_FORMAT(bh.dueDate, '%d-%m-%Y') AS BILL_DUE_DATE,
	T6.displayName AS ACADEMY_NAME,
    ml.code as LANGUAGE_KEY,
    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID
FROM
    bill_header bh
        JOIN
    bill_fee_plan_rule_stage bfprs ON bfprs.billId = bh.id
        JOIN
    students s ON s.userId = bh.studentId
        JOIN
    persons p ON p.id = s.personId
        LEFT JOIN
    salutations sal ON sal.id = p.salutationId
 		LEFT JOIN
    academy_location T6 ON T6.id = bh.academyLocationId
        LEFT JOIN
    fire_base_persons_info f ON f.userId = s.userId
    LEFT JOIN 
    multi_language ml on ml.id=p.correspondence_language
WHERE
    bh.id IN (namedParams)
        AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED') group by bh.id
" WHERE `dataProviderId`=@studentReminderOnDueDay;

-- 7)OUTSTANDING_BILL_STU_REM_ON_DAY_S2_RCPNT
SET @studentReminderOnDueDay2=(SELECT id FROM dtprovider WHERE `dataProviderName`='OUTSTANDING_BILL_STU_REM_ON_DAY_S2_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`=
"SELECT 
    bh.id AS ID,
    SUM(bfprs.balanceAmount) as OUTSTANDING_AMT,
    bh.studentId,
    p.emailId AS EMAIL_ID,
    p.mobileNumber AS MOBILE_NO,
    p.mobileCountryCode AS MOBILE_CODE,
    p.printName AS PRINT_NAME,
    p.firstName AS FIRST_NAME,
    p.lastName AS LAST_NAME,
    sal.salutationName AS SALUTATION_NAME,
    bh.billNo AS BILL_NO,
    DATE_FORMAT(bh.billingDate, '%d-%m-%Y') AS BILL_DATE,
    DATE_FORMAT(bh.dueDate, '%d-%m-%Y') AS BILL_DUE_DATE,
	T6.displayName AS ACADEMY_NAME,
    ml.code as LANGUAGE_KEY,
    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID
FROM
    bill_header bh
        JOIN
    bill_fee_plan_rule_stage bfprs ON bfprs.billId = bh.id
        JOIN
    students s ON s.userId = bh.studentId
        JOIN
    persons p ON p.id = s.personId
        LEFT JOIN
    salutations sal ON sal.id = p.salutationId
 		LEFT JOIN
    academy_location T6 ON T6.id = bh.academyLocationId
        LEFT JOIN
    fire_base_persons_info f ON f.userId = s.userId
		LEFT JOIN
    multi_language ml on ml.id=p.correspondence_language
WHERE
    bh.id IN (namedParams)
        AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED') group by bh.id" 
WHERE `dataProviderId`=@studentReminderOnDueDay2;


-- 8)OUTSTANDING_BILL_FATHER_REMINDER_ON_DUE_DAY_S1

SET @fatherReminderOnDueDay1=(SELECT id FROM dtprovider WHERE `dataProviderName`='OUTSTANDING_BILL_FATHER_REM_ON_DAY_S1_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`=
"SELECT 
    bh.id AS ID,
    SUM(bfprs.balanceAmount) AS OUTSTANDING_AMT,
    bh.studentId,
    T7.emailId AS EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    sal.salutationName AS SALUTATION_NAME,
    bh.billNo AS BILL_NO,
    DATE_FORMAT(bh.billingDate, '%d-%m-%Y') AS BILL_DATE,
    DATE_FORMAT(bh.dueDate, '%d-%m-%Y') AS BILL_DUE_DATE,
    T6.displayName AS ACADEMY_NAME,
    ml.code as LANGUAGE_KEY
FROM
    bill_header bh
        INNER JOIN
    bill_fee_plan_rule_stage bfprs ON bfprs.billId = bh.id
        INNER JOIN
    students s ON s.userId = bh.studentId
        INNER JOIN
    persons p ON p.id = s.personId
        INNER JOIN
    academy_location T6 ON T6.id = bh.academyLocationId
        INNER JOIN
    person_relationships T8 ON T8.personId = p.id
        INNER JOIN
    persons AS T7 ON T7.id = T8.relatedPersonId
        LEFT JOIN
    salutations sal ON sal.id = T7.salutationId
		LEFT JOIN 
	multi_language ml on ml.id=p.correspondence_language
WHERE
    bh.id IN (namedParams)
        AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
        AND T8.relationship = 'FATHER' group by bh.id" 
WHERE `dataProviderId`=@fatherReminderOnDueDay1;

-- 9)OUTSTANDING_BILL_FATHER_REM_ON_DAY_S2_RCPNT

SET @fatherReminderOnDueDay2=(SELECT id FROM dtprovider WHERE `dataProviderName`='OUTSTANDING_BILL_FATHER_REM_ON_DAY_S2_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`=
"SELECT 
    bh.id AS ID,
    SUM(bfprs.balanceAmount) AS OUTSTANDING_AMT,
    bh.studentId,
    T7.emailId AS EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    sal.salutationName AS SALUTATION_NAME,
    bh.billNo AS BILL_NO,
    DATE_FORMAT(bh.billingDate, '%d-%m-%Y') AS BILL_DATE,
    DATE_FORMAT(bh.dueDate, '%d-%m-%Y') AS BILL_DUE_DATE,
    T6.displayName AS ACADEMY_NAME,
    ml.code as LANGUAGE_KEY
FROM
    bill_header bh
        INNER JOIN
    bill_fee_plan_rule_stage bfprs ON bfprs.billId = bh.id
        INNER JOIN
    students s ON s.userId = bh.studentId
        INNER JOIN
    persons p ON p.id = s.personId
        INNER JOIN
    academy_location T6 ON T6.id = bh.academyLocationId
        INNER JOIN
    person_relationships T8 ON T8.personId = p.id
        INNER JOIN
    persons AS T7 ON T7.id = T8.relatedPersonId
        LEFT JOIN
    salutations sal ON sal.id = T7.salutationId
		LEFT JOIN
	multi_language ml on ml.id=p.correspondence_language
WHERE
    bh.id IN (namedParams)
        AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
        AND T8.relationship = 'FATHER' group by bh.id" 
WHERE `dataProviderId`=@fatherReminderOnDueDay2;

-- 10)OUTSTANDING_BILL_MOTHER_REM_ON_DAY_S1_RCPNT

SET @motherReminderOnDueDay1=(SELECT id FROM dtprovider WHERE `dataProviderName`='OUTSTANDING_BILL_MOTHER_REM_ON_DAY_S1_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`=
"SELECT 
    bh.id AS ID,
    SUM(bfprs.balanceAmount) AS OUTSTANDING_AMT,
    bh.studentId,
    T7.emailId AS EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    sal.salutationName AS SALUTATION_NAME,
    bh.billNo AS BILL_NO,
    DATE_FORMAT(bh.billingDate, '%d-%m-%Y') AS BILL_DATE,
    DATE_FORMAT(bh.dueDate, '%d-%m-%Y') AS BILL_DUE_DATE,
    T6.displayName AS ACADEMY_NAME,
    ml.code as LANGUAGE_KEY
FROM
    bill_header bh
        INNER JOIN
    bill_fee_plan_rule_stage bfprs ON bfprs.billId = bh.id
        INNER JOIN
    students s ON s.userId = bh.studentId
        INNER JOIN
    persons p ON p.id = s.personId
        INNER JOIN
    academy_location T6 ON T6.id = bh.academyLocationId
        INNER JOIN
    person_relationships T8 ON T8.personId = p.id
        INNER JOIN
    persons AS T7 ON T7.id = T8.relatedPersonId
        LEFT JOIN
    salutations sal ON sal.id = T7.salutationId
		LEFT JOIN 
	multi_language ml on ml.id=p.correspondence_language
WHERE
    bh.id IN (namedParams)
        AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
        AND T8.relationship = 'MOTHER' group by bh.id" 
WHERE `dataProviderId`=@motherReminderOnDueDay1;

-- 11)OUTSTANDING_BILL_MOTHER_REM_ON_DAY_S2_RCPNT


SET @motherReminderOnDueDay2=(SELECT id FROM dtprovider WHERE `dataProviderName`='OUTSTANDING_BILL_MOTHER_REM_ON_DAY_S2_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`=
"SELECT 
    bh.id AS ID,
    SUM(bfprs.balanceAmount) AS OUTSTANDING_AMT,
    bh.studentId,
    T7.emailId AS EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    sal.salutationName AS SALUTATION_NAME,
    bh.billNo AS BILL_NO,
    DATE_FORMAT(bh.billingDate, '%d-%m-%Y') AS BILL_DATE,
    DATE_FORMAT(bh.dueDate, '%d-%m-%Y') AS BILL_DUE_DATE,
    T6.displayName AS ACADEMY_NAME,
    ml.code as LANGUAGE_KEY
FROM
    bill_header bh
        INNER JOIN
    bill_fee_plan_rule_stage bfprs ON bfprs.billId = bh.id
        INNER JOIN
    students s ON s.userId = bh.studentId
        INNER JOIN
    persons p ON p.id = s.personId
        INNER JOIN
    academy_location T6 ON T6.id = bh.academyLocationId
        INNER JOIN
    person_relationships T8 ON T8.personId = p.id
        INNER JOIN
    persons AS T7 ON T7.id = T8.relatedPersonId
        LEFT JOIN
    salutations sal ON sal.id = T7.salutationId
		LEFT JOIN 
	multi_language ml on ml.id=p.correspondence_language
WHERE
    bh.id IN (namedParams)
        AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
        AND T8.relationship = 'MOTHER' group by bh.id" 
WHERE `dataProviderId`=@motherReminderOnDueDay2;

-- 12)OUTSTANDING_BILL_FP_REM_ON_DAY_S1_RCPNT

SET @billFPReminderDueDay1=(SELECT id FROM dtprovider WHERE `dataProviderName`='OUTSTANDING_BILL_FP_REM_ON_DAY_S1_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`=
"SELECT 
    bh.id AS ID,
    SUM(bfprs.balanceAmount) AS OUTSTANDING_AMT,
    bh.studentId,
    T7.emailWork AS EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.countryCode AS MOBILE_CODE,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    sal.salutationName AS SALUTATION_NAME,
    bh.billNo AS BILL_NO,
    DATE_FORMAT(bh.billingDate, '%d-%m-%Y') AS BILL_DATE,
    DATE_FORMAT(bh.dueDate, '%d-%m-%Y') AS BILL_DUE_DATE,
    T6.displayName AS ACADEMY_NAME,
    ml.code as LANGUAGE_KEY
FROM
    bill_header bh
        INNER JOIN
    bill_fee_plan_rule_stage bfprs ON bfprs.billId = bh.id
        INNER JOIN
    students s ON s.userId = bh.studentId
        INNER JOIN
    persons p ON p.id = s.personId
        INNER JOIN
    academy_location T6 ON T6.id = bh.academyLocationId
        INNER JOIN
    fee_payer_detail T7 ON T7.personId = p.id
        LEFT JOIN
    salutations sal ON sal.id = T7.salutationId
    LEFT JOIN 
	multi_language ml on ml.id=p.correspondence_language
WHERE
    bh.id IN (namedParams)
        AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED') and T7.personId is not null group by T7.id,bh.id order by T7.id asc limit 1" 
WHERE `dataProviderId`=@billFPReminderDueDay1;

-- 13)OUTSTANDING_BILL_FP_REM_ON_DAY_S2_RCPNT

SET @billFPReminderDueDay2=(SELECT id FROM dtprovider WHERE `dataProviderName`='OUTSTANDING_BILL_FP_REM_ON_DAY_S2_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`=
"SELECT 
    bh.id AS ID,
    SUM(bfprs.balanceAmount) AS OUTSTANDING_AMT,
    bh.studentId,
    T7.emailWork AS EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.countryCode AS MOBILE_CODE,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    sal.salutationName AS SALUTATION_NAME,
    bh.billNo AS BILL_NO,
    DATE_FORMAT(bh.billingDate, '%d-%m-%Y') AS BILL_DATE,
    DATE_FORMAT(bh.dueDate, '%d-%m-%Y') AS BILL_DUE_DATE,
    T6.displayName AS ACADEMY_NAME,
    ml.code as LANGUAGE_KEY
FROM
    bill_header bh
        INNER JOIN
    bill_fee_plan_rule_stage bfprs ON bfprs.billId = bh.id
        INNER JOIN
    students s ON s.userId = bh.studentId
        INNER JOIN
    persons p ON p.id = s.personId
        INNER JOIN
    academy_location T6 ON T6.id = bh.academyLocationId
        INNER JOIN
    fee_payer_detail T7 ON T7.personId = p.id
        LEFT JOIN
    salutations sal ON sal.id = T7.salutationId
		LEFT JOIN 
	multi_language ml on ml.id=p.correspondence_language
WHERE
    bh.id IN (namedParams)
        AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED') and T7.personId is not null group by T7.id,bh.id order by T7.id asc limit 1" 
WHERE `dataProviderId`=@billFPReminderDueDay2;

-- 14)OUTSTANDING_BILL_STUDENT_REM_ON_3DAY_PRIOR_RCPNT

SET @studentRemOnThreeDayPrior=(SELECT id FROM dtprovider WHERE `dataProviderName`='OUTSTANDING_BILL_STUDENT_REM_ON_3DAY_PRIOR_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`=
"SELECT 
    bh.id AS ID,
    SUM(bfprs.balanceAmount) as OUTSTANDING_AMT,
    bh.studentId,
    p.emailId AS EMAIL_ID,
    p.mobileNumber AS MOBILE_NO,
    p.mobileCountryCode AS MOBILE_CODE,
    p.printName AS PRINT_NAME,
    p.firstName AS FIRST_NAME,
    p.lastName AS LAST_NAME,
    sal.salutationName AS SALUTATION_NAME,
    bh.billNo AS BILL_NO,
    DATE_FORMAT(bh.billingDate, '%d-%m-%Y') AS BILL_DATE,
    DATE_FORMAT(bh.dueDate, '%d-%m-%Y') AS BILL_DUE_DATE,
	T6.displayName AS ACADEMY_NAME,
    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID,
    ml.code as LANGUAGE_KEY
FROM
    bill_header bh
        JOIN
    bill_fee_plan_rule_stage bfprs ON bfprs.billId = bh.id
        JOIN
    students s ON s.userId = bh.studentId
        JOIN
    persons p ON p.id = s.personId
        LEFT JOIN
    salutations sal ON sal.id = p.salutationId
 		LEFT JOIN
    academy_location T6 ON T6.id = bh.academyLocationId
        LEFT JOIN
    fire_base_persons_info f ON f.userId = s.userId
		LEFT JOIN 
    multi_language ml on ml.id=p.correspondence_language
WHERE
    bh.id IN (namedParams)
        AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED') group by bh.id" 
WHERE `dataProviderId`=@studentRemOnThreeDayPrior;

-- 15)OUTSTANDING_BILL_FATHER_REM_ON_3DAY_PRIOR_RCPNT

SET @fatherRemOnThreeDayPrior=(SELECT id FROM dtprovider WHERE `dataProviderName`='OUTSTANDING_BILL_FATHER_REM_ON_3DAY_PRIOR_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`=
"SELECT 
    bh.id AS ID,
    SUM(bfprs.balanceAmount) AS OUTSTANDING_AMT,
    bh.studentId,
    T7.emailId AS EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    sal.salutationName AS SALUTATION_NAME,
    bh.billNo AS BILL_NO,
    DATE_FORMAT(bh.billingDate, '%d-%m-%Y') AS BILL_DATE,
    DATE_FORMAT(bh.dueDate, '%d-%m-%Y') AS BILL_DUE_DATE,
    T6.displayName AS ACADEMY_NAME,
    ml.code as LANGUAGE_KEY
FROM
    bill_header bh
        INNER JOIN
    bill_fee_plan_rule_stage bfprs ON bfprs.billId = bh.id
        INNER JOIN
    students s ON s.userId = bh.studentId
        INNER JOIN
    persons p ON p.id = s.personId
        INNER JOIN
    academy_location T6 ON T6.id = bh.academyLocationId
        INNER JOIN
    person_relationships T8 ON T8.personId = p.id
        INNER JOIN
    persons AS T7 ON T7.id = T8.relatedPersonId
        LEFT JOIN
    salutations sal ON sal.id = T7.salutationId
		LEFT JOIN 
	multi_language ml on ml.id=p.correspondence_language
WHERE
    bh.id IN (namedParams)
        AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
        AND T8.relationship = 'FATHER' group by bh.id" 
WHERE `dataProviderId`=@fatherRemOnThreeDayPrior;

-- 16)OUTSTANDING_BILL_MOTHER_REM_ON_3DAY_PRIOR_RCPNT

SET @motherRemOnThreeDayPrior=(SELECT id FROM dtprovider WHERE `dataProviderName`='OUTSTANDING_BILL_MOTHER_REM_ON_3DAY_PRIOR_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`=
"SELECT 
    bh.id AS ID,
    SUM(bfprs.balanceAmount) AS OUTSTANDING_AMT,
    bh.studentId,
    T7.emailId AS EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    sal.salutationName AS SALUTATION_NAME,
    bh.billNo AS BILL_NO,
    DATE_FORMAT(bh.billingDate, '%d-%m-%Y') AS BILL_DATE,
    DATE_FORMAT(bh.dueDate, '%d-%m-%Y') AS BILL_DUE_DATE,
    T6.displayName AS ACADEMY_NAME,
    ml.code as LANGUAGE_KEY
FROM
    bill_header bh
        INNER JOIN
    bill_fee_plan_rule_stage bfprs ON bfprs.billId = bh.id
        INNER JOIN
    students s ON s.userId = bh.studentId
        INNER JOIN
    persons p ON p.id = s.personId
        INNER JOIN
    academy_location T6 ON T6.id = bh.academyLocationId
        INNER JOIN
    person_relationships T8 ON T8.personId = p.id
        INNER JOIN
    persons AS T7 ON T7.id = T8.relatedPersonId
        LEFT JOIN
    salutations sal ON sal.id = T7.salutationId
		LEFT JOIN 
    multi_language ml on ml.id=p.correspondence_language
WHERE
    bh.id IN (namedParams)
        AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
        AND T8.relationship = 'MOTHER' group by bh.id" 
WHERE `dataProviderId`=@motherRemOnThreeDayPrior;

-- 17)OUTSTANDING_BILL_FP_REM_ON_3DAY_PRIOR_RCPNT	

SET @billFPRemOnThreeDayPrior=(SELECT id FROM dtprovider WHERE `dataProviderName`='OUTSTANDING_BILL_FP_REM_ON_3DAY_PRIOR_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`=
"SELECT 
    bh.id AS ID,
    SUM(bfprs.balanceAmount) AS OUTSTANDING_AMT,
    bh.studentId,
    T7.emailWork AS EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.countryCode AS MOBILE_CODE,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    sal.salutationName AS SALUTATION_NAME,
    bh.billNo AS BILL_NO,
    DATE_FORMAT(bh.billingDate, '%d-%m-%Y') AS BILL_DATE,
    DATE_FORMAT(bh.dueDate, '%d-%m-%Y') AS BILL_DUE_DATE,
    T6.displayName AS ACADEMY_NAME,
    ml.code as LANGUAGE_KEY
FROM
    bill_header bh
        INNER JOIN
    bill_fee_plan_rule_stage bfprs ON bfprs.billId = bh.id
        INNER JOIN
    students s ON s.userId = bh.studentId
        INNER JOIN
    persons p ON p.id = s.personId
        INNER JOIN
    academy_location T6 ON T6.id = bh.academyLocationId
        INNER JOIN
    fee_payer_detail T7 ON T7.personId = p.id
        LEFT JOIN
    salutations sal ON sal.id = T7.salutationId
   	 	LEFT JOIN 
	multi_language ml on ml.id=p.correspondence_language
WHERE
    bh.id IN (namedParams)
        AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED') and T7.personId is not null group by T7.id,bh.id order by T7.id asc limit 1" 
WHERE `dataProviderId`=@billFPRemOnThreeDayPrior;

-- 18)OUTSTANDING_BILL_STUDENT_REM_RCPNT		

SET @outstandingBillStudentReminder=(SELECT id FROM dtprovider WHERE `dataProviderName`='OUTSTANDING_BILL_STUDENT_REM_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`=
"SELECT 
    bh.id AS ID,
    SUM(bfprs.balanceAmount) as OUTSTANDING_AMT,
    bh.studentId,
    p.emailId AS EMAIL_ID,
    p.mobileNumber AS MOBILE_NO,
    p.mobileCountryCode AS MOBILE_CODE,
    p.printName AS PRINT_NAME,
    p.firstName AS FIRST_NAME,
    p.lastName AS LAST_NAME,
    sal.salutationName AS SALUTATION_NAME,
    bh.billNo AS BILL_NO,
    DATE_FORMAT(bh.billingDate, '%d-%m-%Y') AS BILL_DATE,
    DATE_FORMAT(bh.dueDate, '%d-%m-%Y') AS BILL_DUE_DATE,
	T6.displayName AS ACADEMY_NAME,
    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID,
    ml.code as LANGUAGE_KEY
FROM
    bill_header bh
        JOIN
    bill_fee_plan_rule_stage bfprs ON bfprs.billId = bh.id
        JOIN
    students s ON s.userId = bh.studentId
        JOIN
    persons p ON p.id = s.personId
        LEFT JOIN
    salutations sal ON sal.id = p.salutationId
 		LEFT JOIN
    academy_location T6 ON T6.id = bh.academyLocationId
        LEFT JOIN
    fire_base_persons_info f ON f.userId = s.userId
		LEFT JOIN 
    multi_language ml on ml.id=p.correspondence_language
WHERE
    bh.id IN (namedParams)
        AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED') group by bh.id" 
WHERE `dataProviderId`=@outstandingBillStudentReminder;

-- 19)OUTSTANDING_BILL_FATHER_REM_RCPNT		

SET @outstandingBillFatherReminder=(SELECT id FROM dtprovider WHERE `dataProviderName`='OUTSTANDING_BILL_FATHER_REM_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`=
"SELECT 
    bh.id AS ID,
    SUM(bfprs.balanceAmount) AS OUTSTANDING_AMT,
    bh.studentId,
    T7.emailId AS EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    sal.salutationName AS SALUTATION_NAME,
    bh.billNo AS BILL_NO,
    DATE_FORMAT(bh.billingDate, '%d-%m-%Y') AS BILL_DATE,
    DATE_FORMAT(bh.dueDate, '%d-%m-%Y') AS BILL_DUE_DATE,
    T6.displayName AS ACADEMY_NAME,
    ml.code as LANGUAGE_KEY
FROM
    bill_header bh
        INNER JOIN
    bill_fee_plan_rule_stage bfprs ON bfprs.billId = bh.id
        INNER JOIN
    students s ON s.userId = bh.studentId
        INNER JOIN
    persons p ON p.id = s.personId
        INNER JOIN
    academy_location T6 ON T6.id = bh.academyLocationId
        INNER JOIN
    person_relationships T8 ON T8.personId = p.id
        INNER JOIN
    persons AS T7 ON T7.id = T8.relatedPersonId
        LEFT JOIN
    salutations sal ON sal.id = T7.salutationId
		LEFT JOIN 
    multi_language ml on ml.id=p.correspondence_language
WHERE
    bh.id IN (namedParams)
        AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
        AND T8.relationship = 'FATHER' group by bh.id" 
WHERE `dataProviderId`=@outstandingBillFatherReminder;

-- 20)OUTSTANDING_BILL_MOTHER_REM_RCPNT		

SET @outstandingBillMotherReminder=(SELECT id FROM dtprovider WHERE `dataProviderName`='OUTSTANDING_BILL_MOTHER_REM_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`=
"SELECT 
    bh.id AS ID,
    SUM(bfprs.balanceAmount) AS OUTSTANDING_AMT,
    bh.studentId,
    T7.emailId AS EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    sal.salutationName AS SALUTATION_NAME,
    bh.billNo AS BILL_NO,
    DATE_FORMAT(bh.billingDate, '%d-%m-%Y') AS BILL_DATE,
    DATE_FORMAT(bh.dueDate, '%d-%m-%Y') AS BILL_DUE_DATE,
    T6.displayName AS ACADEMY_NAME,
    ml.code as LANGUAGE_KEY
FROM
    bill_header bh
        INNER JOIN
    bill_fee_plan_rule_stage bfprs ON bfprs.billId = bh.id
        INNER JOIN
    students s ON s.userId = bh.studentId
        INNER JOIN
    persons p ON p.id = s.personId
        INNER JOIN
    academy_location T6 ON T6.id = bh.academyLocationId
        INNER JOIN
    person_relationships T8 ON T8.personId = p.id
        INNER JOIN
    persons AS T7 ON T7.id = T8.relatedPersonId
        LEFT JOIN
    salutations sal ON sal.id = T7.salutationId
		LEFT JOIN 
	multi_language ml on ml.id=p.correspondence_language
WHERE
    bh.id IN (namedParams)
        AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED')
        AND T8.relationship = 'MOTHER' group by bh.id" 
WHERE `dataProviderId`=@outstandingBillMotherReminder;

-- 21)OUTSTANDING_BILL_FP_REM_RCPNT			

SET @outstandingBillFPReminder=(SELECT id FROM dtprovider WHERE `dataProviderName`='OUTSTANDING_BILL_FP_REM_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`=
"SELECT 
    bh.id AS ID,
    SUM(bfprs.balanceAmount) AS OUTSTANDING_AMT,
    bh.studentId,
    T7.emailWork AS EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.countryCode AS MOBILE_CODE,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    sal.salutationName AS SALUTATION_NAME,
    bh.billNo AS BILL_NO,
    DATE_FORMAT(bh.billingDate, '%d-%m-%Y') AS BILL_DATE,
    DATE_FORMAT(bh.dueDate, '%d-%m-%Y') AS BILL_DUE_DATE,
    T6.displayName AS ACADEMY_NAME,
    ml.code as LANGUAGE_KEY
FROM
    bill_header bh
        INNER JOIN
    bill_fee_plan_rule_stage bfprs ON bfprs.billId = bh.id
        INNER JOIN
    students s ON s.userId = bh.studentId
        INNER JOIN
    persons p ON p.id = s.personId
        INNER JOIN
    academy_location T6 ON T6.id = bh.academyLocationId
        INNER JOIN
    fee_payer_detail T7 ON T7.personId = p.id
        LEFT JOIN
    salutations sal ON sal.id = T7.salutationId
		LEFT JOIN
	multi_language ml on ml.id=p.correspondence_language
WHERE
    bh.id IN (namedParams)
        AND bh.billStatus NOT IN ('CANCELLED' , 'SETTLED') and T7.personId is not null group by T7.id,bh.id order by T7.id asc limit 1" 
WHERE `dataProviderId`=@outstandingBillFPReminder;



SET SQL_SAFE_UPDATES=1;